<?php
    /**
    *
    * copyright (c) 2013-2022 Heliac Technologies
    * license http://opensource.org/licenses/gpl-license.php GNU GPL v3 
    *
    * linee guida per l'utilizzo del logo http://www.geecom.org/index.php?alias=linee-guida-per-luso-del-logo-geecom
    *
    */

    include "../../include/includeBaseControllerComponenti.php";
    include "../classi/MetroSlider.php";
    
    if(isset($_POST["operazione"])) {
        $operazione = filter_input(INPUT_POST,"operazione",FILTER_SANITIZE_STRING);
        $metroSlider = new MetroSlider($geecomDb, filter_input(INPUT_POST, "id"));
    }
    else {
        $operazione = filter_input(INPUT_GET,"operazione",FILTER_SANITIZE_STRING);
        $metroSlider = new MetroSlider($geecomDb, filter_input(INPUT_GET, "id"));
    }
    
    switch ($operazione) {
        case 'crea':
            $metroSlider->setNome(filter_input(INPUT_POST,"nome",FILTER_SANITIZE_ADD_SLASHES));
            $metroSlider->setSpazioOccupato(filter_input(INPUT_POST,"spazioOccupato",FILTER_SANITIZE_STRING));
            $metroSlider->setArticoliPerSlide(filter_input(INPUT_POST,"articoliPerSlide",FILTER_SANITIZE_NUMBER_INT));
            $metroSlider->crea();
            header("Location: ../creaMetro.php?id={$metroSlider->getId()}&status=200");
            break;
        case 'modifica':
            $metroSlider->setNome(filter_input(INPUT_POST,"nome",FILTER_SANITIZE_ADD_SLASHES));
            $metroSlider->setSpazioOccupato(filter_input(INPUT_POST,"spazioOccupato",FILTER_SANITIZE_STRING));
            $metroSlider->setArticoliPerSlide(filter_input(INPUT_POST,"articoliPerSlide",FILTER_SANITIZE_NUMBER_INT));
            $metroSlider->modifica();
            header("Location: ../creaMetro.php?id={$metroSlider->getId()}&status=250");
            break;
        case 'elimina':
            $metroSlider->elimina();
            echo "ok";
            break;
        case 'duplica':
            $metroSlider->caricaDatiDalDatabase();
            $idNuovaForm = $metroSlider->duplica();
            header("Location: ../MetroSlider.php?id={$idNuovaForm}&status=260");
            break;
        case 'stampaElementi':
            $metroSlider->stampaElementi();
            break;
        case 'creaElemento':
            $metroSlider->creaElemento(filter_input(INPUT_POST, "nome",FILTER_SANITIZE_STRING),filter_input(INPUT_POST, "tipo",FILTER_SANITIZE_STRING));
            echo "ok";
            break;
        case 'spostaElemento':
            $metroSlider->spostaElemento(filter_input(INPUT_POST, "idElemento",FILTER_SANITIZE_NUMBER_INT),filter_input(INPUT_POST, "posizione",FILTER_SANITIZE_NUMBER_INT));
            echo "ok";
            break;
        case 'modificaElemento':
            $idElemento = filter_input(INPUT_POST,"idElemento",FILTER_SANITIZE_STRING);
            $nome       = filter_input(INPUT_POST,"nome",FILTER_SANITIZE_STRING);
            $lingua     = filter_input(INPUT_POST,"linguaContenuti",FILTER_SANITIZE_STRING);
            $contenuto0 = isset($_POST["contenuto0"]) ? filter_input(INPUT_POST,"contenuto0",FILTER_SANITIZE_STRING) : 0;
            $contenuto1 = isset($_POST["contenuto1"]) ? filter_input(INPUT_POST,"contenuto1",FILTER_SANITIZE_STRING) : 0;
            $contenuto2 = isset($_POST["contenuto2"]) ? filter_input(INPUT_POST,"contenuto2",FILTER_SANITIZE_STRING) : 0;
            $contenuto3 = isset($_POST["contenuto3"]) ? filter_input(INPUT_POST,"contenuto3",FILTER_SANITIZE_STRING) : 0;
            $contenuto4 = isset($_POST["contenuto4"]) ? filter_input(INPUT_POST,"contenuto4",FILTER_SANITIZE_STRING) : 0;
            $contenuti  = "$contenuto0,$contenuto1,$contenuto2,$contenuto3,$contenuto4";
            $tipo       = filter_input(INPUT_POST,"tipo",FILTER_SANITIZE_STRING);
            $metroSlider->modificaElemento($idElemento,$nome,$tipo,$lingua,$contenuti);
            header("Location: ../creaElemento.php?id={$idElemento}&status=200");
            break;
        case 'duplicaElemento':
            $idElemento = filter_input(INPUT_GET,"idElemento",FILTER_SANITIZE_STRING);
            $idElementoDuplicato = $metroSlider->duplicaElemento($idElemento);
            header("Location: ../creaElemento.php?id={$idElementoDuplicato}&status=220");
            break;
        case 'modificaImmagineElemento':
            $idElemento      = filter_input(INPUT_POST, "idElemento",FILTER_SANITIZE_NUMBER_INT);
            $tipiFileAmmessi = array("image/png","image/jpeg","image/gif");
            $gestoreUpload = new GestoreUpload("file", $tipiFileAmmessi, 8, "../../../../immagini/slider", 0, $categoria->getNome());
            $esitoUpload  = $gestoreUpload->salvaFile();
            if($esitoUpload["fileElaborati"]==1) {
                if($esitoUpload["percorso"]!="") {
                    $percorsoFoto = str_replace("../","",$esitoUpload["percorso"]);
                }
                // se nelle impostazioni è spuintata la voce  "ottimizza immagini caricate" viene modificata
                if($impostazioni["ottimizzaImmaginiCaricate"]=="si") {
                    $elaboratoreImmagini = new ElaboratoreImmagini($esitoUpload["percorso"]);
                    if($elaboratoreImmagini->getAltezza()>$impostazioni["altezzaImmagine"]) {
                        $elaboratoreImmagini->modificaInScala("altezza", $impostazioni["altezzaImmagine"], $esitoUpload["percorso"]);
                    }
                }
            }
            else {
                $percorsoFoto = "";
            }
            $metroSlider->cambiaImmagineElemento($idElemento,$percorsoFoto);
            
            // se nelle impostazioni è spuintata la voce  "ottimizza immagini caricate" viene modificata
            if($impostazioni["ottimizzaImmaginiCaricate"]=="si") {
                $elaboratoreImmagini = new ElaboratoreImmagini($esitoUpload["percorso"]);
                if($elaboratoreImmagini->getAltezza()>$impostazioni["altezzaImmagine"]) {
                    $elaboratoreImmagini->modificaInScala("altezza", $impostazioni["altezzaImmagine"], $esitoUpload["percorso"]);
                }
            }

            if($impostazioni["generaThumbnail"]=="si") {
                $percorsoFileThumbnail = str_replace("immagini/","immagini/thumbnail/",$esitoUpload["percorso"]);
                $percorsoThumbnail = str_replace("../","",$percorsoFileThumbnail);
                $elaboratoreImmagini->modificaInScala("altezza", $impostazioni["altezzaThumbnail"], $percorsoFileThumbnail);
            }
            
            echo "../../../$percorsoFoto";
            break;
        case 'eliminaElemento':
            $metroSlider->eliminaElemento(filter_input(INPUT_POST, "idElemento",FILTER_SANITIZE_NUMBER_INT));
            echo "ok";
            break;
    }
